/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.js.debug.core.internal.browsers;

import com.aptana.core.logging.IdeLog;
import com.aptana.core.util.FirefoxUtil;
import com.aptana.js.debug.core.JSDebugPlugin;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.LineNumberReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Plugin;

public final class FirebugUtil {
    private static final String PREF_FORMAT = "user_pref(\"extensions.firebug.externalEditors{0}\", \"{1}\");";

    private FirebugUtil() {
    }

    public static boolean registerEditor(String name, IPath path, String cmdLine) {
        String id = name.replaceAll("\\W", "_");
        return FirebugUtil.registerEditor(id, name, path, cmdLine);
    }

    public static boolean registerEditor(String id, String name, IPath path, String cmdLine) {
        IPath profile = FirefoxUtil.findDefaultProfileLocation();
        if (profile == null) {
            return false;
        }
        HashMap<String, String> options = new HashMap<String, String>();
        options.put("label", name);
        options.put("executable", path.toOSString());
        options.put("cmdline", cmdLine);
        options.put("image", "");
        IPath prefs = profile.append("prefs.js");
        BufferedReader reader = null;
        PrintWriter writer = null;
        try {
            try {
                String line;
                reader = new LineNumberReader(new InputStreamReader((InputStream)new FileInputStream(prefs.toFile()), "UTF8"));
                ArrayList<String> lines = new ArrayList<String>();
                boolean editorsFound = false;
                boolean doWrite = false;
                Pattern prefPattern = Pattern.compile("^user_pref\\(\"extensions\\.firebug\\.externalEditors(.*)\", \"(.*)\"\\);$");
                while ((line = ((LineNumberReader)reader).readLine()) != null) {
                    Matcher matcher = prefPattern.matcher(line);
                    if (matcher.find()) {
                        String option;
                        String editorId;
                        int index;
                        String pref = matcher.group(1);
                        String value = matcher.group(2);
                        if (pref.length() == 0) {
                            editorsFound = true;
                            String[] editors = value.split(",");
                            boolean addEntry = true;
                            String[] stringArray = editors;
                            int n = editors.length;
                            int n2 = 0;
                            while (n2 < n) {
                                String editor = stringArray[n2];
                                if (id.equals(editor.trim())) {
                                    addEntry = false;
                                    break;
                                }
                                ++n2;
                            }
                            if (addEntry) {
                                line = MessageFormat.format(PREF_FORMAT, pref, String.valueOf(value) + ',' + id);
                                doWrite = true;
                            }
                        } else if (pref.charAt(0) == '.' && (index = pref.indexOf(46, 1)) > 0 && id.equals(editorId = pref.substring(1, index)) && options.containsKey(option = pref.substring(index + 1))) {
                            if (!value.equals(options.get(option))) {
                                value = (String)options.get(option);
                                line = value.length() > 0 ? MessageFormat.format(PREF_FORMAT, pref, value) : null;
                                doWrite = true;
                            }
                            options.remove(option);
                        }
                    }
                    if (line == null) continue;
                    lines.add(line);
                }
                reader.close();
                reader = null;
                if (!editorsFound) {
                    lines.add(MessageFormat.format(PREF_FORMAT, "", id));
                    doWrite = true;
                }
                if (!options.isEmpty()) {
                    for (Map.Entry entry : options.entrySet()) {
                        if (((String)entry.getValue()).length() <= 0) continue;
                        lines.add(MessageFormat.format(PREF_FORMAT, String.valueOf('.') + id + '.' + (String)entry.getKey(), entry.getValue()));
                        doWrite = true;
                    }
                }
                if (doWrite) {
                    writer = new PrintWriter(new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(prefs.toFile()), "UTF8")));
                    for (String string : lines) {
                        writer.println(string);
                    }
                }
            }
            catch (IOException e) {
                IdeLog.logError((Plugin)JSDebugPlugin.getDefault(), (String)MessageFormat.format("Reading '{0}' fails", prefs.toOSString()), (Throwable)e);
                if (reader != null) {
                    try {
                        reader.close();
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                }
                if (writer != null) {
                    writer.close();
                }
            }
        }
        finally {
            if (reader != null) {
                try {
                    reader.close();
                }
                catch (IOException iOException) {}
            }
            if (writer != null) {
                writer.close();
            }
        }
        return true;
    }
}

